<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'birth_of_date', 'blood_type_id', 'donation_last_date', 'city_id', 'number', 'password');

    public function orders()
    {
        return $this->hasMany('App\Http\Models\Order');
    }

    public function notifications()
    {
        return $this->hasMany('App\Http\Models\Notification');
    }

    public function blood_type()
    {
        return $this->hasOne('App\Http\Models\BloodType');
    }

}